<?php 
    /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class Video {
        private $db;
        private $id;
        private $nome;
        private $spazioOccupato;
        private $stile;
        private $animazioneVideo;
        private $animazioneTesto;
        private $video; 
        
        public function __construct($db, $id, $nome="", $spazioOccupato = "", $stile="", $animazioneVideo="", $animazioneTesto="", $video="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome = $nome;
            $this->spazioOccupato = $spazioOccupato;
            $this->stile = $stile;
            $this->animazioneVideo = $animazioneVideo;
            $this->animazioneTesto = $animazioneTesto;
            $this->video = $video;
        }

        function crea() {
            $query    = "INSERT INTO geec_video VALUES(NULL,'$this->nome','$this->spazioOccupato','$this->stile','$this->animazioneVideo','$this->animazioneTesto','$this->video')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE geec_video SET nome='$this->nome', spazioOccupato='$this->spazioOccupato', stile='$this->stile', animazioneVideo='$this->animazioneVideo', video='$this->video' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_video",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 19
            eliminaOccorrenzeComponente($this->db,$this->id,19);
        }
        
        function caricaDatiDalDatabase() {
            $datiVideo = $this->db->leggiSingolaRiga("geec_video",$this->id);
            $this->nome            = $datiVideo["nome"];
            $this->spazioOccupato  = $datiVideo["spazioOccupato"];
            $this->stile           = $datiVideo["stile"];
            $this->animazioneVideo = $datiVideo["animazioneVideo"];
            $this->animazioneTesto = $datiVideo["animazioneTesto"];
            $this->video           = $datiVideo["video"];
        }
        
        function duplica($prefisso = "Copia di ") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_video WHERE id={$this->id}");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_video SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_video SET nome = CONCAT('$prefisso', ' ', nome) WHERE id=$idContenutoDuplicato");
            return $idContenutoDuplicato;
        }
        
        function aggiornaPercorsoVideo($percorsoVideo) {
            $query    = "UPDATE geec_video SET video='$percorsoVideo' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        /*
         * getter & setter
         */
        
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getStile() {
            return $this->stile;
        }

        public function getPosizioneVideo() {
            return $this->posizioneVideo;
        }

        public function getAnimazioneVideo() {
            return $this->animazioneVideo;
        }

        public function getAnimazioneTesto() {
            return $this->animazioneTesto;
        }

        public function getVideo() {
            return $this->video;
        }

        public function setDb($db) {
            $this->db = $db;
        }

        public function setId($id) {
            $this->id = $id;
        }

        public function setNome($nome) {
            $this->nome = $nome;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function setSpazioOccupato($spazioOccupato) {
            $this->spazioOccupato = $spazioOccupato;
        }

        public function setStile($stile) {
            $this->stile = $stile;
        }

        public function setPosizioneVideo($posizioneVideo) {
            $this->posizioneVideo = $posizioneVideo;
        }

        public function setAnimazioneVideo($animazioneVideo) {
            $this->animazioneVideo = $animazioneVideo;
        }

        public function setAnimazioneTesto($animazioneTesto) {
            $this->animazioneTesto = $animazioneTesto;
        }

        public function setVideo($video) {
            $this->video = $video;
        }

    }